//Header file for a window position set.  It is used to space new windows so that each new untitled
//document or window doesn't sit on top of the last one, and to ensure that windows that are created,
//whether as new untitled documents, or loaded from a file, are actually visible on-screen.

//Conventions:
//    Global constants (declared with const) and #defines - all uppercase letters with words separated 
//        by underscores.
//        (E.G., #define MY_DEFINE 5).
//        (E.G., const int MY_CONSTANT = 5;).
//    New data types (classes, structs, typedefs, etc.) - begin with an uppercase letter followed by
//        lowercase words separated by uppercase letters.  Enumerated constants contain a prefix
//        associating them with a particular enumerated set.
//        (E.G., typedef int MyTypedef;).
//        (E.G., enum MyEnumConst {MEC_ONE, MEC_TWO};)
//    Global variables - begin with "g_" followed by lowercase words separated by underscores.
//        (E.G., int g_my_global;).
//    Local variables - begin with a lowercase letter followed by lowercase words separated by
//        underscores.
//        (E.G., int my_local;).
//    Argument variables - begin with "a_" followed by lowercase words separated by underscores.
//        (E.G., ...int a_my_argument, ...).
//    Member variables - begin with "m_" followed by lowercase words separated by underscores.
//        (E.G., int m_my_member;).
//    Functions (member or global) - begin with an uppercase letter followed by lowercase words
//        separated by uppercase letters.
//        (E.G., void MyFunction(void);).


#ifndef _SGB_WINDOW_POSITION_SET_H_
#define _SGB_WINDOW_POSITION_SET_H_


//******************************************************************************************************
//**** SYSTEM HEADER FILES
//******************************************************************************************************
#include <Rect.h>


//******************************************************************************************************
//**** WindowPositionSet CLASS
//******************************************************************************************************
class WindowPositionSet
{
	public:
		WindowPositionSet(BRect a_initial_default = BRect(30.0,30.0,430.0,280.0), bool a_fixed_window_size = false);
			//a_initial_default specifies the position for the first untitled window created to occupy.  As subsequent
			//	untitled windows are created, they will be shifted to keep them from overlapping.
			//a_fixed_window_size tells it not to shrink the window to fit, that the size must not be changed.
		void CheckWindowPosition(BWindow* a_window);
		void CheckWindowPosition(BRect* a_rect);
			//Checks the position of a window.  If it is completely offscreen, moves it onscreen.  Typically this is used to
			//check the position of a window for a document that has been loaded from a file.
		void SetSizeLimits(float a_min_width, float a_max_width, float a_min_height, float a_max_height);
			//Set size limits for windows to be created
		void GetSizeLimits(float* a_min_width, float* a_max_width, float* a_min_height, float* a_max_height);
			//Get size limits for windows to be created
		BRect GetNextUntitledWindow();
			//Gets the BRect that represents the next untitled window, shifting it relative to the previously created 
			//one, and ensuring that it is entirely visible onscreen.
		void WindowClosingSetDefault(BWindow* a_window);
			//In some contexts, the user closing a window should make that the default size and position for the next
			//window opened.  Call this from your window's Quit method or destructor to obtain this behavior.
		BRect GetCurrentDefault();
			//Gets the current default window position.  Typically this is called in order to save preferences
			//information for the next time the program is run.
		void SetCurrentDefault(BRect a_rect);
			//Allows the current default to be reset, for example after having read the user preference.

	private:
		BRect m_initial_default;
		BRect m_current_default;
		BRect m_last_origin;
		bool m_fixed_window_size;
		float m_min_width;
		float m_min_height;
		float m_max_width;
		float m_max_height;
};


#endif
